local assets =
{
	Asset("ANIM", "anim/wood.zip"),
    Asset("ATLAS", "images/inventoryimages/wood.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("wood")
    inst.AnimState:SetBuild("wood")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "wood"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wood.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    MakeHauntableLaunchAndSmash(inst)
	inst.Transform:SetScale(1.5, 1.5, 1.5)

    return inst
end

return Prefab("wood", fn, assets)